/*
 * Decompiled with CFR 0.152.
 */
package com.baidu.mapapi.map;

import android.graphics.Bitmap;
import android.graphics.Color;
import android.graphics.Point;
import android.graphics.Rect;
import android.os.Bundle;
import android.os.Parcelable;
import android.text.TextUtils;
import android.util.Log;
import android.view.MotionEvent;
import android.view.View;
import android.view.ViewGroup;
import com.baidu.mapapi.common.SysOSUtil;
import com.baidu.mapapi.map.BitmapDescriptor;
import com.baidu.mapapi.map.BitmapDescriptorFactory;
import com.baidu.mapapi.map.HeatMap;
import com.baidu.mapapi.map.InfoWindow;
import com.baidu.mapapi.map.MapBaseIndoorMapInfo;
import com.baidu.mapapi.map.MapLayer;
import com.baidu.mapapi.map.MapPoi;
import com.baidu.mapapi.map.MapStatus;
import com.baidu.mapapi.map.MapStatusUpdate;
import com.baidu.mapapi.map.MapStatusUpdateFactory;
import com.baidu.mapapi.map.MapView;
import com.baidu.mapapi.map.MapViewLayoutParams;
import com.baidu.mapapi.map.Marker;
import com.baidu.mapapi.map.MarkerOptions;
import com.baidu.mapapi.map.MyLocationConfiguration;
import com.baidu.mapapi.map.MyLocationData;
import com.baidu.mapapi.map.Overlay;
import com.baidu.mapapi.map.OverlayOptions;
import com.baidu.mapapi.map.Polyline;
import com.baidu.mapapi.map.Projection;
import com.baidu.mapapi.map.TextureMapView;
import com.baidu.mapapi.map.TileOverlay;
import com.baidu.mapapi.map.TileOverlayOptions;
import com.baidu.mapapi.map.UiSettings;
import com.baidu.mapapi.map.WearMapView;
import com.baidu.mapapi.map.a;
import com.baidu.mapapi.map.b;
import com.baidu.mapapi.map.c;
import com.baidu.mapapi.map.d;
import com.baidu.mapapi.map.e;
import com.baidu.mapapi.model.CoordUtil;
import com.baidu.mapapi.model.LatLng;
import com.baidu.mapapi.model.LatLngBounds;
import com.baidu.mapapi.model.ParcelItem;
import com.baidu.mapapi.model.inner.GeoPoint;
import com.baidu.mapsdkplatform.comapi.map.ae;
import com.baidu.mapsdkplatform.comapi.map.af;
import com.baidu.mapsdkplatform.comapi.map.ag;
import com.baidu.mapsdkplatform.comapi.map.l;
import com.baidu.mapsdkplatform.comapi.map.n;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import javax.microedition.khronos.opengles.GL10;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class BaiduMap {
    public static final int MAP_TYPE_NORMAL = 1;
    public static final int MAP_TYPE_SATELLITE = 2;
    public static final int MAP_TYPE_NONE = 3;
    public static int mapStatusReason = 0;
    private static final String e = BaiduMap.class.getSimpleName();
    private Projection f;
    private UiSettings g;
    private n h;
    private com.baidu.mapsdkplatform.comapi.map.e i;
    private ag j;
    private List<Overlay> k;
    private List<Marker> l;
    private List<Marker> m;
    private List<InfoWindow> n;
    private Overlay.a o;
    private InfoWindow.a p;
    private OnMapStatusChangeListener q;
    private OnMapTouchListener r;
    private OnMapClickListener s;
    private OnMapLoadedCallback t;
    private OnMapRenderCallback u;
    private OnMapDoubleClickListener v;
    private OnMapLongClickListener w;
    private CopyOnWriteArrayList<OnMarkerClickListener> x = new CopyOnWriteArrayList();
    private CopyOnWriteArrayList<OnPolylineClickListener> y = new CopyOnWriteArrayList();
    private OnMarkerDragListener z;
    private OnMyLocationClickListener A;
    private SnapshotReadyCallback B;
    private OnMapDrawFrameCallback C;
    private OnBaseIndoorMapListener D;
    private OnMapRenderValidDataListener E;
    private OnSynchronizationListener F;
    private TileOverlay G;
    private HeatMap H;
    private Lock I = new ReentrantLock();
    private Lock J = new ReentrantLock();
    private Map<String, InfoWindow> K;
    private Map<InfoWindow, Marker> L;
    private Marker M;
    private MyLocationData N;
    private MyLocationConfiguration O;
    MapView a;
    TextureMapView b;
    WearMapView c;
    ae d;
    private boolean P;
    private boolean Q;
    private boolean R;
    private boolean S;
    private Point T;

    private void c() {
        this.k = new CopyOnWriteArrayList<Overlay>();
        this.l = new CopyOnWriteArrayList<Marker>();
        this.m = new CopyOnWriteArrayList<Marker>();
        this.K = new ConcurrentHashMap<String, InfoWindow>();
        this.L = new ConcurrentHashMap<InfoWindow, Marker>();
        this.n = new CopyOnWriteArrayList<InfoWindow>();
        int n2 = (int)(40.0f * SysOSUtil.getDensity());
        int n3 = (int)(40.0f * SysOSUtil.getDensity());
        this.T = new Point(n2, n3);
        this.g = new UiSettings(this.i);
        this.o = new a(this);
        this.p = new b(this);
        c c2 = new c(this);
        this.i.a(c2);
        d d2 = new d(this);
        this.i.a(d2);
        e e2 = new e(this);
        this.i.a(e2);
        this.P = this.i.C();
        this.Q = this.i.D();
    }

    BaiduMap(ag ag2) {
        this.j = ag2;
        this.i = this.j.b();
        this.d = ae.b;
        this.c();
    }

    BaiduMap(n n2) {
        this.h = n2;
        this.i = this.h.a();
        this.d = ae.a;
        this.c();
    }

    public final Overlay addOverlay(OverlayOptions overlayOptions) {
        Marker marker;
        if (overlayOptions == null) {
            return null;
        }
        Overlay overlay = overlayOptions.a();
        overlay.listener = this.o;
        if (overlay instanceof Marker) {
            marker = (Marker)overlay;
            marker.x = this.p;
            if (marker.p != null && marker.p.size() != 0) {
                this.l.add(marker);
                if (this.i != null) {
                    this.i.b(true);
                }
            }
            this.m.add(marker);
            if (marker.w != null) {
                this.showInfoWindow(marker.w, false);
            }
        }
        marker = new Bundle();
        overlay.a((Bundle)marker);
        if (this.i != null) {
            this.i.b((Bundle)marker);
        }
        this.k.add(overlay);
        return overlay;
    }

    public final List<Overlay> addOverlays(List<OverlayOptions> list) {
        Object object;
        if (list == null) {
            return null;
        }
        ArrayList<Overlay> arrayList = new ArrayList<Overlay>();
        Bundle[] bundleArray = new Bundle[list.size()];
        int n2 = 0;
        for (OverlayOptions overlayOptions : list) {
            if (overlayOptions == null) continue;
            object = new Bundle();
            Overlay overlay = overlayOptions.a();
            overlay.listener = this.o;
            if (overlay instanceof Marker) {
                Marker marker = (Marker)overlay;
                marker.x = this.p;
                if (marker.p != null && marker.p.size() != 0) {
                    this.l.add(marker);
                    if (this.i != null) {
                        this.i.b(true);
                    }
                }
                this.m.add(marker);
            }
            this.k.add(overlay);
            arrayList.add(overlay);
            overlay.a((Bundle)object);
            bundleArray[n2] = object;
            ++n2;
        }
        int n3 = bundleArray.length / 400;
        for (int i2 = 0; i2 < n3 + 1; ++i2) {
            object = new ArrayList();
            for (int i3 = 0; i3 < 400 && i2 * 400 + i3 < bundleArray.length; ++i3) {
                if (bundleArray[i2 * 400 + i3] == null) continue;
                object.add(bundleArray[i2 * 400 + i3]);
            }
            if (this.i == null) continue;
            this.i.a((List<Bundle>)object);
        }
        return arrayList;
    }

    public List<Marker> getMarkersInBounds(LatLngBounds latLngBounds) {
        MapStatus mapStatus = this.getMapStatus();
        if (mapStatus == null) {
            return null;
        }
        ArrayList<Marker> arrayList = new ArrayList<Marker>();
        if (this.m.size() == 0) {
            return null;
        }
        for (Marker marker : this.m) {
            if (!latLngBounds.contains(marker.getPosition())) continue;
            arrayList.add(marker);
        }
        return arrayList;
    }

    public final void clear() {
        this.k.clear();
        this.l.clear();
        this.m.clear();
        if (this.i != null) {
            this.i.b(false);
            this.i.n();
        }
        this.hideInfoWindow();
    }

    public final void setMapStatus(MapStatusUpdate mapStatusUpdate) {
        if (mapStatusUpdate == null) {
            return;
        }
        af af2 = this.a(mapStatusUpdate);
        if (this.i == null) {
            return;
        }
        this.i.a(af2);
        if (this.q != null) {
            this.q.onMapStatusChange(this.getMapStatus());
        }
    }

    public final MapStatus getMapStatus() {
        if (this.i == null) {
            return null;
        }
        af af2 = this.i.E();
        return MapStatus.a(af2);
    }

    public final LatLngBounds getMapStatusLimit() {
        if (this.i == null) {
            return null;
        }
        return this.i.F();
    }

    public final void setMapStatusLimits(LatLngBounds latLngBounds) {
        if (this.i == null) {
            return;
        }
        this.i.a(latLngBounds);
        MapStatusUpdate mapStatusUpdate = MapStatusUpdateFactory.newLatLngBounds(latLngBounds);
        this.setMapStatus(mapStatusUpdate);
    }

    public final void animateMapStatus(MapStatusUpdate mapStatusUpdate, int n2) {
        if (mapStatusUpdate == null || n2 <= 0) {
            return;
        }
        af af2 = this.a(mapStatusUpdate);
        if (this.i == null) {
            return;
        }
        mapStatusReason |= 0x100;
        if (!this.S) {
            this.i.a(af2);
        } else {
            this.i.a(af2, n2);
        }
    }

    public float getZoomToBound(int n2, int n3, int n4, int n5, int n6, int n7) {
        if (this.i == null) {
            return 0.0f;
        }
        return this.i.a(n2, n3, n4, n5, n6, n7);
    }

    public final void animateMapStatus(MapStatusUpdate mapStatusUpdate) {
        this.animateMapStatus(mapStatusUpdate, 300);
    }

    private af a(MapStatusUpdate mapStatusUpdate) {
        if (this.i == null) {
            return null;
        }
        af af2 = this.i.E();
        MapStatus mapStatus = mapStatusUpdate.a(this.i, this.getMapStatus());
        if (null == mapStatus) {
            return null;
        }
        af af3 = mapStatus.b(af2);
        return af3;
    }

    public final void setMapType(int n2) {
        if (this.i == null) {
            return;
        }
        switch (n2) {
            case 3: {
                if (this.i.C()) {
                    this.i.v(false);
                }
                if (this.i.D()) {
                    this.i.w(false);
                }
                this.i.g(false);
                this.i.l(false);
                break;
            }
            case 1: {
                this.i.a(false);
                this.i.v(this.P);
                this.i.w(this.Q);
                this.i.g(true);
                this.i.l(this.R);
                break;
            }
            case 2: {
                this.i.a(true);
                this.i.v(this.P);
                this.i.w(this.Q);
                this.i.g(true);
                break;
            }
        }
        if (this.h != null) {
            this.h.a(n2);
        }
    }

    public final int getMapType() {
        if (this.i == null) {
            return 1;
        }
        if (!this.i.l()) {
            return 3;
        }
        return this.i.k() ? 2 : 1;
    }

    @Deprecated
    public n getmGLMapView() {
        return this.h;
    }

    public n getGLMapView() {
        return this.h;
    }

    public final float getMaxZoomLevel() {
        if (this.i == null) {
            return 0.0f;
        }
        return this.i.a;
    }

    public final void setMaxAndMinZoomLevel(float f2, float f3) {
        if (f2 > 21.0f) {
            return;
        }
        if (f3 < 4.0f) {
            return;
        }
        if (f2 < f3) {
            return;
        }
        if (this.i != null) {
            this.i.a(f2, f3);
        }
    }

    public final float getMinZoomLevel() {
        if (this.i == null) {
            return 0.0f;
        }
        return this.i.b;
    }

    public final Projection getProjection() {
        return this.f;
    }

    public final UiSettings getUiSettings() {
        return this.g;
    }

    public final void setBuildingsEnabled(boolean bl) {
        if (this.i != null) {
            this.i.j(bl);
        }
    }

    public final boolean isBuildingsEnabled() {
        if (this.i == null) {
            return false;
        }
        return this.i.m();
    }

    public final void setMyLocationEnabled(boolean bl) {
        if (this.i != null) {
            this.i.o(bl);
        }
    }

    public final boolean isMyLocationEnabled() {
        if (this.i == null) {
            return false;
        }
        return this.i.s();
    }

    public final void setMyLocationData(MyLocationData myLocationData) {
        this.N = myLocationData;
        if (this.O == null) {
            this.O = new MyLocationConfiguration(MyLocationConfiguration.LocationMode.NORMAL, false, null);
        }
        this.a(myLocationData, this.O);
    }

    public final MyLocationData getLocationData() {
        return this.N;
    }

    public final void setMyLocationConfiguration(MyLocationConfiguration myLocationConfiguration) {
        this.O = myLocationConfiguration;
        this.a(this.N, this.O);
    }

    @Deprecated
    public final void setMyLocationConfigeration(MyLocationConfiguration myLocationConfiguration) {
        this.setMyLocationConfiguration(myLocationConfiguration);
    }

    public final MyLocationConfiguration getLocationConfiguration() {
        return this.O;
    }

    @Deprecated
    public final MyLocationConfiguration getLocationConfigeration() {
        return this.getLocationConfiguration();
    }

    private final void a(MyLocationData myLocationData, MyLocationConfiguration myLocationConfiguration) {
        Object object;
        Bundle bundle;
        if (myLocationData == null || myLocationConfiguration == null || !this.isMyLocationEnabled()) {
            return;
        }
        JSONObject jSONObject = new JSONObject();
        JSONArray jSONArray = new JSONArray();
        JSONObject jSONObject2 = new JSONObject();
        JSONObject jSONObject3 = new JSONObject();
        LatLng latLng = new LatLng(myLocationData.latitude, myLocationData.longitude);
        GeoPoint geoPoint = CoordUtil.ll2mc(latLng);
        try {
            jSONObject.put("type", 0);
            jSONObject2.put("ptx", geoPoint.getLongitudeE6());
            jSONObject2.put("pty", geoPoint.getLatitudeE6());
            float f2 = CoordUtil.getMCDistanceByOneLatLngAndRadius(latLng, (int)myLocationData.accuracy);
            jSONObject2.put("radius", (double)f2);
            float f3 = myLocationData.direction;
            if (myLocationConfiguration.enableDirection) {
                f3 = myLocationData.direction % 360.0f;
                if (f3 > 180.0f) {
                    f3 -= 360.0f;
                } else if (f3 < -180.0f) {
                    f3 += 360.0f;
                }
            } else {
                f3 = -1001.0f;
            }
            jSONObject2.put("direction", (double)f3);
            jSONObject2.put("iconarrownor", (Object)"NormalLocArrow");
            jSONObject2.put("iconarrownorid", 28);
            jSONObject2.put("iconarrowfoc", (Object)"FocusLocArrow");
            jSONObject2.put("iconarrowfocid", 29);
            jSONObject2.put("lineid", myLocationConfiguration.accuracyCircleStrokeColor);
            jSONObject2.put("areaid", myLocationConfiguration.accuracyCircleFillColor);
            jSONArray.put((Object)jSONObject2);
            jSONObject.put("data", (Object)jSONArray);
            if (myLocationConfiguration.locationMode == MyLocationConfiguration.LocationMode.COMPASS) {
                jSONObject3.put("ptx", geoPoint.getLongitudeE6());
                jSONObject3.put("pty", geoPoint.getLatitudeE6());
                jSONObject3.put("radius", 0);
                jSONObject3.put("direction", 0);
                jSONObject3.put("iconarrownor", (Object)"direction_wheel");
                jSONObject3.put("iconarrownorid", 54);
                jSONObject3.put("iconarrowfoc", (Object)"direction_wheel");
                jSONObject3.put("iconarrowfocid", 54);
                jSONArray.put((Object)jSONObject3);
            }
        }
        catch (JSONException jSONException) {
            jSONException.printStackTrace();
        }
        if (myLocationConfiguration.customMarker == null) {
            bundle = null;
        } else {
            ArrayList<BitmapDescriptor> arrayList = new ArrayList<BitmapDescriptor>();
            arrayList.add(myLocationConfiguration.customMarker);
            bundle = new Bundle();
            object = new ArrayList();
            for (BitmapDescriptor bitmapDescriptor : arrayList) {
                ParcelItem parcelItem = new ParcelItem();
                Bundle bundle2 = new Bundle();
                Bitmap bitmap = bitmapDescriptor.a;
                ByteBuffer byteBuffer = ByteBuffer.allocate(bitmap.getWidth() * bitmap.getHeight() * 4);
                bitmap.copyPixelsToBuffer((Buffer)byteBuffer);
                byte[] byArray = byteBuffer.array();
                bundle2.putByteArray("imgdata", byArray);
                bundle2.putInt("imgindex", bitmapDescriptor.hashCode());
                bundle2.putInt("imgH", bitmap.getHeight());
                bundle2.putInt("imgW", bitmap.getWidth());
                parcelItem.setBundle(bundle2);
                ((ArrayList)object).add(parcelItem);
            }
            if (((ArrayList)object).size() > 0) {
                Parcelable[] parcelableArray = new ParcelItem[((ArrayList)object).size()];
                for (int i2 = 0; i2 < ((ArrayList)object).size(); ++i2) {
                    parcelableArray[i2] = (ParcelItem)((ArrayList)object).get(i2);
                }
                bundle.putParcelableArray("icondata", parcelableArray);
            }
        }
        if (this.i != null) {
            this.i.a(jSONObject.toString(), bundle);
        }
        switch (myLocationConfiguration.locationMode) {
            case COMPASS: {
                MapStatus mapStatus = new MapStatus.Builder().rotate(myLocationData.direction).overlook(-45.0f).target(new LatLng(myLocationData.latitude, myLocationData.longitude)).targetScreen(this.getMapStatus().targetScreen).zoom(this.getMapStatus().zoom).build();
                object = MapStatusUpdateFactory.newMapStatus(mapStatus);
                this.animateMapStatus((MapStatusUpdate)object);
                break;
            }
            case FOLLOWING: {
                MapStatus mapStatus = new MapStatus.Builder().target(new LatLng(myLocationData.latitude, myLocationData.longitude)).zoom(this.getMapStatus().zoom).rotate(this.getMapStatus().rotate).overlook(this.getMapStatus().overlook).targetScreen(this.getMapStatus().targetScreen).build();
                object = MapStatusUpdateFactory.newMapStatus(mapStatus);
                this.animateMapStatus((MapStatusUpdate)object);
                break;
            }
            case NORMAL: {
                break;
            }
        }
    }

    public void addHeatMap(HeatMap heatMap) {
        if (heatMap == null || this.i == null) {
            return;
        }
        this.I.lock();
        try {
            if (heatMap == this.H) {
                return;
            }
            if (this.H != null) {
                this.H.b();
                this.H.c();
                this.H.a = null;
                this.i.o();
            }
            this.H = heatMap;
            this.H.a = this;
            this.i.p(true);
        }
        finally {
            this.I.unlock();
        }
    }

    void a(HeatMap heatMap) {
        this.I.lock();
        try {
            if (this.H != null && this.i != null && heatMap == this.H) {
                this.H.b();
                this.H.c();
                this.H.a = null;
                this.i.o();
                this.H = null;
                this.i.p(false);
            }
        }
        finally {
            this.I.unlock();
        }
    }

    void a() {
        if (this.i == null) {
            return;
        }
        this.i.t();
    }

    public final void setBaiduHeatMapEnabled(boolean bl) {
        if (this.i != null) {
            this.i.h(bl);
        }
    }

    public final void setIndoorEnable(boolean bl) {
        if (this.i != null) {
            this.R = bl;
            this.i.l(bl);
        }
        if (this.D != null && !bl) {
            this.D.onBaseIndoorMapMode(false, null);
        }
    }

    public void setCompassPosition(Point point) {
        if (this.i == null) {
            return;
        }
        if (this.i.a(point)) {
            this.T = point;
        }
    }

    public void setCompassIcon(Bitmap bitmap) {
        if (bitmap == null) {
            throw new IllegalArgumentException("BDMapSDKException: compass's icon can not be null");
        }
        if (this.i == null) {
            return;
        }
        this.i.a(bitmap);
    }

    public final Point getCompassPosition() {
        if (this.i != null) {
            String string = this.i.h();
            return this.a(string);
        }
        return null;
    }

    private Point a(String string) {
        if (TextUtils.isEmpty((CharSequence)string)) {
            return null;
        }
        int n2 = 0;
        int n3 = 0;
        for (String string2 : string.replaceAll("^\\{", "").replaceAll("\\}$", "").split(",")) {
            String[] stringArray = string2.replaceAll("\"", "").split(":");
            if ("x".equals(stringArray[0])) {
                n2 = Integer.valueOf(stringArray[1]);
            }
            if (!"y".equals(stringArray[0])) continue;
            n3 = Integer.valueOf(stringArray[1]);
        }
        return new Point(n2, n3);
    }

    public final boolean isBaiduHeatMapEnabled() {
        if (this.i == null) {
            return false;
        }
        return this.i.i();
    }

    public final boolean isSupportBaiduHeatMap() {
        if (this.i == null) {
            return false;
        }
        return this.i.j();
    }

    public final void setTrafficEnabled(boolean bl) {
        if (this.i != null) {
            this.i.i(bl);
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    public boolean setCustomTrafficColor(String string, String string2, String string3, String string4) {
        if (this.i == null) {
            return false;
        }
        String string5 = "^#[0-9a-fA-F]{8}$";
        if (!(TextUtils.isEmpty((CharSequence)string) || TextUtils.isEmpty((CharSequence)string2) || TextUtils.isEmpty((CharSequence)string3) || TextUtils.isEmpty((CharSequence)string4))) {
            if (string.matches(string5) && string2.matches(string5) && string3.matches(string5) && string4.matches(string5)) {
                this.i.a(Color.parseColor((String)string), Color.parseColor((String)string2), Color.parseColor((String)string3), Color.parseColor((String)string4), true);
                return true;
            }
            Log.e((String)e, (String)"the string of the input customTrafficColor is error");
            return false;
        }
        if (!TextUtils.isEmpty((CharSequence)string)) return true;
        if (!TextUtils.isEmpty((CharSequence)string2)) return true;
        if (!TextUtils.isEmpty((CharSequence)string3)) return true;
        if (!TextUtils.isEmpty((CharSequence)string4)) return true;
        this.i.a(Color.parseColor((String)"#ffffffff"), Color.parseColor((String)"#ffffffff"), Color.parseColor((String)"#ffffffff"), Color.parseColor((String)"#ffffffff"), false);
        return true;
    }

    public final boolean isTrafficEnabled() {
        if (this.i == null) {
            return false;
        }
        return this.i.g();
    }

    public final void showMapPoi(boolean bl) {
        if (this.i != null) {
            this.i.v(bl);
            this.P = bl;
        }
    }

    public final void showMapIndoorPoi(boolean bl) {
        if (this.i != null) {
            this.i.w(bl);
            this.Q = bl;
        }
    }

    @Deprecated
    public final void setPadding(int n2, int n3, int n4, int n5) {
        this.setViewPadding(n2, n3, n4, n5);
    }

    public final void setViewPadding(int n2, int n3, int n4, int n5) {
        if (n2 < 0 || n3 < 0 || n4 < 0 || n5 < 0) {
            return;
        }
        if (this.i == null) {
            return;
        }
        switch (this.d) {
            case b: {
                if (this.b == null) {
                    return;
                }
                float f2 = (float)(this.b.getWidth() - n2 - n4) / (float)this.b.getWidth();
                float f3 = (float)(this.b.getHeight() - n3 - n5) / (float)this.b.getHeight();
                this.i.a(new Point((int)((float)n2 + (float)this.T.x * f2), (int)((float)n3 + (float)this.T.y * f3)));
                this.b.setPadding(n2, n3, n4, n5);
                this.b.invalidate();
                break;
            }
            case a: {
                if (this.a == null) {
                    return;
                }
                float f4 = (float)(this.a.getWidth() - n2 - n4) / (float)this.a.getWidth();
                float f5 = (float)(this.a.getHeight() - n3 - n5) / (float)this.a.getHeight();
                this.i.a(new Point((int)((float)n2 + (float)this.T.x * f4), (int)((float)n3 + (float)this.T.y * f5)));
                this.a.setPadding(n2, n3, n4, n5);
                this.a.invalidate();
                break;
            }
        }
    }

    public final void snapshot(SnapshotReadyCallback snapshotReadyCallback) {
        this.B = snapshotReadyCallback;
        switch (this.d) {
            case b: {
                if (this.j == null) break;
                this.j.a("anything", null);
                break;
            }
            case a: {
                if (this.h == null) break;
                this.h.a("anything", null);
                break;
            }
        }
    }

    public final void snapshotScope(Rect rect, SnapshotReadyCallback snapshotReadyCallback) {
        this.B = snapshotReadyCallback;
        switch (this.d) {
            case b: {
                if (this.j == null) break;
                this.j.a("anything", rect);
                break;
            }
            case a: {
                if (this.h == null) break;
                this.h.a("anything", rect);
                break;
            }
        }
    }

    public void showInfoWindow(InfoWindow infoWindow) {
        this.showInfoWindow(infoWindow, true);
    }

    public void showInfoWindow(InfoWindow infoWindow, boolean bl) {
        Object object;
        Object object2;
        BitmapDescriptor bitmapDescriptor;
        Set<InfoWindow> set = this.L.keySet();
        if (infoWindow == null || set.contains(infoWindow)) {
            return;
        }
        if (bl) {
            this.hideInfoWindow();
        }
        boolean bl2 = true;
        infoWindow.e = this.p;
        if (infoWindow.b != null && infoWindow.j) {
            bitmapDescriptor = infoWindow.b;
            bitmapDescriptor.destroyDrawingCache();
            object2 = new MapViewLayoutParams.Builder();
            object = ((MapViewLayoutParams.Builder)object2).layoutMode(MapViewLayoutParams.ELayoutMode.mapMode).position(infoWindow.c).yOffset(infoWindow.f).build();
            switch (this.d) {
                case b: {
                    if (this.b == null) break;
                    this.b.addView((View)bitmapDescriptor, (ViewGroup.LayoutParams)object);
                    break;
                }
                case a: {
                    if (this.h == null) break;
                    this.a.addView((View)bitmapDescriptor, (ViewGroup.LayoutParams)object);
                    break;
                }
            }
            if (infoWindow.i) {
                bl2 = false;
            }
        }
        if ((bitmapDescriptor = this.b(infoWindow)) == null) {
            return;
        }
        object2 = new MarkerOptions().perspective(false).icon(bitmapDescriptor).position(infoWindow.c).zIndex(Integer.MAX_VALUE).yOffset(infoWindow.f).infoWindow(infoWindow);
        object = ((MarkerOptions)object2).a();
        ((Overlay)object).listener = this.o;
        ((Overlay)object).type = com.baidu.mapsdkplatform.comapi.map.l.b;
        Bundle bundle = new Bundle();
        ((Overlay)object).a(bundle);
        if (infoWindow.b != null) {
            bundle.putInt("draw_with_view", 1);
        } else {
            bundle.putInt("draw_with_view", 0);
        }
        if (this.i != null && bl2) {
            this.i.b(bundle);
            this.k.add((Overlay)object);
        }
        Marker marker = (Marker)object;
        marker.x = this.p;
        this.K.put(marker.z, infoWindow);
        this.L.put(infoWindow, marker);
        this.n.add(infoWindow);
    }

    public void showInfoWindows(List<InfoWindow> list) {
        if (null == list || list.isEmpty()) {
            return;
        }
        for (InfoWindow infoWindow : list) {
            this.showInfoWindow(infoWindow, false);
        }
    }

    public List<InfoWindow> getAllInfoWindows() {
        return this.n;
    }

    public void hideInfoWindow() {
        View view;
        Collection<InfoWindow> collection = this.K.values();
        if (!collection.isEmpty()) {
            for (InfoWindow object : collection) {
                if (null == object || null == (view = object.b)) continue;
                switch (this.d) {
                    case b: {
                        if (null == this.b) break;
                        this.b.removeView(view);
                        break;
                    }
                    case a: {
                        if (null == this.a) break;
                        this.a.removeView(view);
                        break;
                    }
                }
            }
        }
        for (Overlay overlay : this.k) {
            view = this.K.keySet();
            String string = overlay.z;
            if (!(overlay instanceof Marker) || view.isEmpty() || !view.contains(string)) continue;
            overlay.remove();
        }
        this.K.clear();
        this.L.clear();
        this.n.clear();
    }

    public void hideInfoWindow(InfoWindow infoWindow) {
        Marker marker;
        Set<InfoWindow> set = this.L.keySet();
        if (null == infoWindow || set.isEmpty() || !set.contains(infoWindow)) {
            return;
        }
        View view = infoWindow.b;
        if (null != view) {
            switch (this.d) {
                case b: {
                    if (null == this.b) break;
                    this.b.removeView(view);
                    break;
                }
                case a: {
                    if (null == this.a) break;
                    this.a.removeView(view);
                    break;
                }
            }
        }
        if (null != (marker = this.L.get(infoWindow))) {
            marker.remove();
            this.K.remove(marker.z);
        }
        this.L.remove(infoWindow);
        this.n.remove(infoWindow);
    }

    private void a(InfoWindow infoWindow) {
        Object object;
        Object object2;
        if (null == infoWindow) {
            return;
        }
        Set<InfoWindow> set = this.L.keySet();
        if (set.isEmpty() || !set.contains(infoWindow)) {
            this.showInfoWindow(infoWindow, false);
            return;
        }
        boolean bl = true;
        View view = infoWindow.b;
        if (null != view && infoWindow.j) {
            view.destroyDrawingCache();
            object2 = new MapViewLayoutParams.Builder();
            object = ((MapViewLayoutParams.Builder)object2).layoutMode(MapViewLayoutParams.ELayoutMode.mapMode).position(infoWindow.c).yOffset(infoWindow.f).build();
            switch (this.d) {
                case b: {
                    if (null == this.b) break;
                    this.b.removeView(view);
                    this.b.addView(view, (ViewGroup.LayoutParams)object);
                    break;
                }
                case a: {
                    if (null == this.a) break;
                    this.a.removeView(view);
                    this.a.addView(view, (ViewGroup.LayoutParams)object);
                    break;
                }
            }
            if (infoWindow.i) {
                bl = false;
            }
        }
        object2 = this.b(infoWindow);
        object = this.L.get(infoWindow);
        if (null != object) {
            Bundle bundle = new Bundle();
            if (infoWindow.a != null) {
                ((Marker)object).type = com.baidu.mapsdkplatform.comapi.map.l.b;
                ((Marker)object).b = object2;
                if (infoWindow.b != null) {
                    bundle.putInt("draw_with_view", 1);
                } else {
                    bundle.putInt("draw_with_view", 0);
                }
            }
            ((Marker)object).a = infoWindow.c;
            ((Marker)object).a(bundle);
            if (this.i != null && bl) {
                this.i.c(bundle);
            }
        }
    }

    private BitmapDescriptor b(InfoWindow infoWindow) {
        BitmapDescriptor bitmapDescriptor;
        if (infoWindow.b != null && infoWindow.j) {
            if (infoWindow.g) {
                if (infoWindow.h <= 0) {
                    infoWindow.h = SysOSUtil.getDensityDpi();
                }
                bitmapDescriptor = BitmapDescriptorFactory.fromViewWithDpi(infoWindow.b, infoWindow.h);
            } else {
                bitmapDescriptor = BitmapDescriptorFactory.fromView(infoWindow.b);
            }
            infoWindow.a = bitmapDescriptor;
        } else {
            bitmapDescriptor = infoWindow.a;
        }
        return bitmapDescriptor;
    }

    public void setPixelFormatTransparent(boolean bl) {
        if (this.h == null) {
            return;
        }
        if (bl) {
            this.h.d();
        } else {
            this.h.e();
        }
    }

    public final void setOnMapStatusChangeListener(OnMapStatusChangeListener onMapStatusChangeListener) {
        this.q = onMapStatusChangeListener;
    }

    public final void setOnMapTouchListener(OnMapTouchListener onMapTouchListener) {
        this.r = onMapTouchListener;
    }

    public final void setOnMapClickListener(OnMapClickListener onMapClickListener) {
        this.s = onMapClickListener;
    }

    public void setOnMapLoadedCallback(OnMapLoadedCallback onMapLoadedCallback) {
        this.t = onMapLoadedCallback;
    }

    public void setOnMapRenderCallbadk(OnMapRenderCallback onMapRenderCallback) {
        this.u = onMapRenderCallback;
    }

    public final void setOnMapDoubleClickListener(OnMapDoubleClickListener onMapDoubleClickListener) {
        this.v = onMapDoubleClickListener;
    }

    public final void setOnMapLongClickListener(OnMapLongClickListener onMapLongClickListener) {
        this.w = onMapLongClickListener;
    }

    public final void setOnPolylineClickListener(OnPolylineClickListener onPolylineClickListener) {
        if (onPolylineClickListener != null) {
            this.y.add(onPolylineClickListener);
        }
    }

    public final void setOnMarkerClickListener(OnMarkerClickListener onMarkerClickListener) {
        if (onMarkerClickListener != null && !this.x.contains(onMarkerClickListener)) {
            this.x.add(onMarkerClickListener);
        }
    }

    public final void setOnMarkerDragListener(OnMarkerDragListener onMarkerDragListener) {
        this.z = onMarkerDragListener;
    }

    public final void setOnMyLocationClickListener(OnMyLocationClickListener onMyLocationClickListener) {
        this.A = onMyLocationClickListener;
    }

    public final void setOnMapDrawFrameCallback(OnMapDrawFrameCallback onMapDrawFrameCallback) {
        this.C = onMapDrawFrameCallback;
    }

    public final void setOnBaseIndoorMapListener(OnBaseIndoorMapListener onBaseIndoorMapListener) {
        this.D = onBaseIndoorMapListener;
    }

    public final void setOnMapRenderValidDataListener(OnMapRenderValidDataListener onMapRenderValidDataListener) {
        this.E = onMapRenderValidDataListener;
    }

    private String a(int n2) {
        String string = "";
        switch (n2) {
            case 0: {
                string = "\u6570\u636e\u8bf7\u6c42\u6210\u529f";
                break;
            }
            case 1004: {
                string = "\u7f51\u7edc\u8fde\u63a5\u9519\u8bef";
                break;
            }
            case 1005: {
                string = "\u8bf7\u6c42\u53d1\u9001\u9519\u8bef";
                break;
            }
            case 1006: {
                string = "\u54cd\u5e94\u6570\u636e\u8bfb\u53d6\u5931\u8d25";
                break;
            }
            case 1007: {
                string = "\u8fd4\u56de\u54cd\u5e94\u6570\u636e\u8fc7\u5927\uff0c\u6570\u636e\u6ea2\u51fa";
                break;
            }
            case 1008: {
                string = "\u5f53\u524d\u7f51\u7edc\u7c7b\u578b\u6709\u95ee\u9898";
                break;
            }
            case 1009: {
                string = "\u6570\u636e\u4e0d\u4e00\u81f4";
                break;
            }
            case 1010: {
                string = "\u8bf7\u6c42\u53d6\u6d88";
                break;
            }
            case 1011: {
                string = "\u7f51\u7edc\u8d85\u65f6\u9519\u8bef";
                break;
            }
            case 1012: {
                string = "\u7f51\u7edc\u8fde\u63a5\u8d85\u65f6";
                break;
            }
            case 1013: {
                string = "\u7f51\u7edc\u53d1\u9001\u8d85\u65f6";
                break;
            }
            case 1014: {
                string = "\u7f51\u7edc\u63a5\u6536\u8d85\u65f6";
                break;
            }
            case 1015: {
                string = "DNS\u89e3\u6790\u9519\u8bef";
                break;
            }
            case 1016: {
                string = "DNS\u89e3\u6790\u8d85\u65f6";
                break;
            }
            case 1017: {
                string = "\u7f51\u7edc\u5199\u9519\u8bef";
                break;
            }
            case 1018: {
                string = "SSL\u63e1\u624b\u9519\u8bef";
                break;
            }
            case 1019: {
                string = "SSL\u63e1\u624b\u8d85\u65f6";
                break;
            }
        }
        return string;
    }

    public final void setOnSynchronizationListener(OnSynchronizationListener onSynchronizationListener) {
        this.F = onSynchronizationListener;
    }

    public MapBaseIndoorMapInfo getFocusedBaseIndoorMapInfo() {
        if (null == this.i) {
            return null;
        }
        return this.i.p();
    }

    public MapBaseIndoorMapInfo.SwitchFloorError switchBaseIndoorMapFloor(String string, String string2) {
        if (TextUtils.isEmpty((CharSequence)string) || TextUtils.isEmpty((CharSequence)string2)) {
            return MapBaseIndoorMapInfo.SwitchFloorError.FLOOR_INFO_ERROR;
        }
        MapBaseIndoorMapInfo mapBaseIndoorMapInfo = this.getFocusedBaseIndoorMapInfo();
        if (null == mapBaseIndoorMapInfo) {
            return MapBaseIndoorMapInfo.SwitchFloorError.SWITCH_ERROR;
        }
        if (!string2.equals(mapBaseIndoorMapInfo.a)) {
            return MapBaseIndoorMapInfo.SwitchFloorError.FOCUSED_ID_ERROR;
        }
        ArrayList<String> arrayList = mapBaseIndoorMapInfo.getFloors();
        if (arrayList == null || !arrayList.contains(string)) {
            return MapBaseIndoorMapInfo.SwitchFloorError.FLOOR_OVERLFLOW;
        }
        if (this.i != null && this.i.a(string, string2)) {
            return MapBaseIndoorMapInfo.SwitchFloorError.SWITCH_OK;
        }
        return MapBaseIndoorMapInfo.SwitchFloorError.SWITCH_ERROR;
    }

    public boolean isBaseIndoorMapMode() {
        if (null == this.i) {
            return false;
        }
        return this.i.q();
    }

    public final void removeMarkerClickListener(OnMarkerClickListener onMarkerClickListener) {
        if (this.x.contains(onMarkerClickListener)) {
            this.x.remove(onMarkerClickListener);
        }
    }

    public TileOverlay addTileLayer(TileOverlayOptions tileOverlayOptions) {
        if (tileOverlayOptions == null) {
            return null;
        }
        if (this.G != null) {
            this.G.b();
            this.G.a = null;
        }
        if (this.i != null && this.i.a(tileOverlayOptions.a())) {
            TileOverlay tileOverlay;
            this.G = tileOverlay = tileOverlayOptions.a(this);
            return tileOverlay;
        }
        return null;
    }

    public void hideSDKLayer() {
        if (null == this.i) {
            return;
        }
        this.i.c();
    }

    public void showSDKLayer() {
        if (null == this.i) {
            return;
        }
        this.i.d();
    }

    public void changeLocationLayerOrder(boolean bl) {
        if (null == this.i) {
            return;
        }
        this.i.d(bl);
    }

    public void setCompassEnable(boolean bl) {
        if (null == this.i) {
            return;
        }
        this.i.e(bl);
    }

    boolean b() {
        if (this.i == null) {
            return false;
        }
        return this.i.e();
    }

    void a(TileOverlay tileOverlay) {
        this.J.lock();
        try {
            if (tileOverlay != null && this.G == tileOverlay) {
                tileOverlay.b();
                tileOverlay.a = null;
                tileOverlay = null;
                if (this.i != null) {
                    this.i.f(false);
                }
            }
        }
        finally {
            this.G = null;
            this.J.unlock();
        }
    }

    public float[] getProjectionMatrix() {
        if (null == this.i) {
            return null;
        }
        return this.i.N();
    }

    public float[] getViewMatrix() {
        if (null == this.i) {
            return null;
        }
        return this.i.O();
    }

    public void setOverlayUnderPoi(boolean bl) {
        if (null == this.i) {
            return;
        }
        this.i.c(bl);
    }

    public void switchLayerOrder(MapLayer mapLayer, MapLayer mapLayer2) {
        if (null == this.i) {
            return;
        }
        this.i.a(mapLayer, mapLayer2);
    }

    public void setLayerClickable(MapLayer mapLayer, boolean bl) {
        if (null == this.i) {
            return;
        }
        this.i.a(mapLayer, bl);
    }

    public void cleanCache(int n2) {
        if (null == this.i) {
            return;
        }
        this.i.b(n2);
    }

    static /* synthetic */ List a(BaiduMap baiduMap) {
        return baiduMap.k;
    }

    static /* synthetic */ com.baidu.mapsdkplatform.comapi.map.e b(BaiduMap baiduMap) {
        return baiduMap.i;
    }

    static /* synthetic */ List c(BaiduMap baiduMap) {
        return baiduMap.m;
    }

    static /* synthetic */ List d(BaiduMap baiduMap) {
        return baiduMap.l;
    }

    static /* synthetic */ void a(BaiduMap baiduMap, InfoWindow infoWindow) {
        baiduMap.a(infoWindow);
    }

    static /* synthetic */ Map e(BaiduMap baiduMap) {
        return baiduMap.K;
    }

    static /* synthetic */ OnMapStatusChangeListener f(BaiduMap baiduMap) {
        return baiduMap.q;
    }

    static /* synthetic */ OnSynchronizationListener g(BaiduMap baiduMap) {
        return baiduMap.F;
    }

    static /* synthetic */ OnMapTouchListener h(BaiduMap baiduMap) {
        return baiduMap.r;
    }

    static /* synthetic */ OnMapClickListener i(BaiduMap baiduMap) {
        return baiduMap.s;
    }

    static /* synthetic */ OnMapDoubleClickListener j(BaiduMap baiduMap) {
        return baiduMap.v;
    }

    static /* synthetic */ OnMapLongClickListener k(BaiduMap baiduMap) {
        return baiduMap.w;
    }

    static /* synthetic */ Projection a(BaiduMap baiduMap, Projection projection) {
        baiduMap.f = projection;
        return baiduMap.f;
    }

    static /* synthetic */ boolean a(BaiduMap baiduMap, boolean bl) {
        baiduMap.S = bl;
        return baiduMap.S;
    }

    static /* synthetic */ OnMapLoadedCallback l(BaiduMap baiduMap) {
        return baiduMap.t;
    }

    static /* synthetic */ OnMapRenderCallback m(BaiduMap baiduMap) {
        return baiduMap.u;
    }

    static /* synthetic */ SnapshotReadyCallback n(BaiduMap baiduMap) {
        return baiduMap.B;
    }

    static /* synthetic */ OnMyLocationClickListener o(BaiduMap baiduMap) {
        return baiduMap.A;
    }

    static /* synthetic */ CopyOnWriteArrayList p(BaiduMap baiduMap) {
        return baiduMap.x;
    }

    static /* synthetic */ CopyOnWriteArrayList q(BaiduMap baiduMap) {
        return baiduMap.y;
    }

    static /* synthetic */ Marker r(BaiduMap baiduMap) {
        return baiduMap.M;
    }

    static /* synthetic */ Projection s(BaiduMap baiduMap) {
        return baiduMap.f;
    }

    static /* synthetic */ OnMarkerDragListener t(BaiduMap baiduMap) {
        return baiduMap.z;
    }

    static /* synthetic */ Marker a(BaiduMap baiduMap, Marker marker) {
        baiduMap.M = marker;
        return baiduMap.M;
    }

    static /* synthetic */ Lock u(BaiduMap baiduMap) {
        return baiduMap.I;
    }

    static /* synthetic */ HeatMap v(BaiduMap baiduMap) {
        return baiduMap.H;
    }

    static /* synthetic */ OnMapDrawFrameCallback w(BaiduMap baiduMap) {
        return baiduMap.C;
    }

    static /* synthetic */ OnBaseIndoorMapListener x(BaiduMap baiduMap) {
        return baiduMap.D;
    }

    static /* synthetic */ OnMapRenderValidDataListener y(BaiduMap baiduMap) {
        return baiduMap.E;
    }

    static /* synthetic */ String a(BaiduMap baiduMap, int n2) {
        return baiduMap.a(n2);
    }

    static /* synthetic */ Lock z(BaiduMap baiduMap) {
        return baiduMap.J;
    }

    static /* synthetic */ TileOverlay A(BaiduMap baiduMap) {
        return baiduMap.G;
    }

    public static interface OnSynchronizationListener {
        public void onMapStatusChangeReason(int var1);
    }

    public static interface OnMapRenderValidDataListener {
        public void onMapRenderValidData(boolean var1, int var2, String var3);
    }

    public static interface OnBaseIndoorMapListener {
        public void onBaseIndoorMapMode(boolean var1, MapBaseIndoorMapInfo var2);
    }

    public static interface OnMapDrawFrameCallback {
        @Deprecated
        public void onMapDrawFrame(GL10 var1, MapStatus var2);

        public void onMapDrawFrame(MapStatus var1);
    }

    public static interface SnapshotReadyCallback {
        public void onSnapshotReady(Bitmap var1);
    }

    public static interface OnMyLocationClickListener {
        public boolean onMyLocationClick();
    }

    public static interface OnMarkerDragListener {
        public void onMarkerDrag(Marker var1);

        public void onMarkerDragEnd(Marker var1);

        public void onMarkerDragStart(Marker var1);
    }

    public static interface OnPolylineClickListener {
        public boolean onPolylineClick(Polyline var1);
    }

    public static interface OnMarkerClickListener {
        public boolean onMarkerClick(Marker var1);
    }

    public static interface OnMapLongClickListener {
        public void onMapLongClick(LatLng var1);
    }

    public static interface OnMapDoubleClickListener {
        public void onMapDoubleClick(LatLng var1);
    }

    public static interface OnMapRenderCallback {
        public void onMapRenderFinished();
    }

    public static interface OnMapLoadedCallback {
        public void onMapLoaded();
    }

    public static interface OnMapClickListener {
        public void onMapClick(LatLng var1);

        public void onMapPoiClick(MapPoi var1);
    }

    public static interface OnMapTouchListener {
        public void onTouch(MotionEvent var1);
    }

    public static interface OnMapStatusChangeListener {
        public static final int REASON_GESTURE = 1;
        public static final int REASON_API_ANIMATION = 2;
        public static final int REASON_DEVELOPER_ANIMATION = 3;

        public void onMapStatusChangeStart(MapStatus var1);

        public void onMapStatusChangeStart(MapStatus var1, int var2);

        public void onMapStatusChange(MapStatus var1);

        public void onMapStatusChangeFinish(MapStatus var1);
    }
}

