/*
 * Decompiled with CFR 0.152.
 */
package com.baidu.mapapi.utils;

import com.baidu.mapapi.model.LatLng;
import com.baidu.mapapi.utils.DistanceUtil;
import java.util.List;

public class AreaUtil {
    public static double calculateArea(LatLng latLng, LatLng latLng2) {
        if (latLng == null || latLng2 == null) {
            return 0.0;
        }
        LatLng latLng3 = new LatLng(latLng.latitude, latLng2.longitude);
        double d2 = 0.0;
        double d3 = 0.0;
        d2 = DistanceUtil.getDistance(latLng3, latLng2);
        d3 = DistanceUtil.getDistance(latLng, latLng3);
        if (d2 == 0.0 || d3 == 0.0) {
            return 0.0;
        }
        return d2 * d3;
    }

    public static double calculateArea(List<LatLng> list) {
        if (list == null || list.size() < 3) {
            return 0.0;
        }
        double d2 = 0.0;
        double d3 = 111319.49079327358;
        int n2 = list.size();
        for (int i2 = 0; i2 < n2; ++i2) {
            LatLng latLng = list.get(i2);
            LatLng latLng2 = list.get((i2 + 1) % n2);
            double d4 = latLng.longitude * d3 * Math.cos(latLng.latitude * (Math.PI / 180));
            double d5 = latLng.latitude * d3;
            double d6 = latLng2.longitude * d3 * Math.cos(latLng2.latitude * (Math.PI / 180));
            double d7 = latLng2.latitude * d3;
            d2 += d4 * d7 - d5 * d6;
        }
        return (float)Math.abs(d2 / 2.0);
    }
}

